package cn.com.duiba.nezha.engine.biz.service.advert.feature.impl;

import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.engine.biz.constant.HbaseContainsByRow;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ResourceFeatureService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class ResourceFeatureServiceImpl implements ResourceFeatureService {

    private static final Logger logger = LoggerFactory.getLogger(ResourceFeatureServiceImpl.class);

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");

    private static final String TABLE_NAME = "consumer_resource_feature";

    private static final byte[] FAMILY = "cf".getBytes();

    @Autowired
    private HbaseTemplate hbaseTemplate;

    private String dayKey(Long consumerId) {

        String k = consumerId+"_"+LocalDate.now().format(DATE_TIME_FORMATTER);

        return this.key(k) + "-" + k;
    }

    private String key(String k) {
        return DigestUtils.md5DigestAsHex(k.getBytes()).substring(0, 4);
    }

    @Override
    @SuppressWarnings("squid:S3776")
    public void get(Long consumerId, FeatureDo featureDo) {


        Map<String, Long> dayResourceOrderRank = new HashMap<>();
        Map<String, Long> dayResourceChargeCnt = new HashMap<>();
        Map<String, Long> dayResourceConvertCnt = new HashMap<>();
        Map<String, String> resourceLastGmtCreateTime = new HashMap<>();
        Map<String, String> resourceLastLaunchOrderId = new HashMap<>();
        Map<String, String> resourceLastClickOrderId = new HashMap<>();
        Map<String, String> resourceLastConvertOrderId = new HashMap<>();

        String dayKey = dayKey(consumerId);
        List<String> keys = Lists.newArrayList(dayKey);

        hbaseTemplate.execute(TABLE_NAME, table -> {

            List<Get> gets = keys.stream().map(key -> new Get(key.getBytes()).addFamily(FAMILY)).collect(Collectors.toList());

            DBTimeProfile.enter("hbaseResourceGet");
            Result[] results = table.get(gets);
            DBTimeProfile.release();

            for (int i = 0; i < keys.size(); i++) {
                Result result = results[i];
                Cell[] cells = result.rawCells();
                for (Cell cell : cells) {
                    String column = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                        String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());

                        if (column.contains(HbaseContainsByRow.LAST_GMT_CODE)) {
                            resourceLastGmtCreateTime.put(column, value);
                        }
                        if (column.contains(HbaseContainsByRow.LAST_LAUNCH_CODE)) {
                            resourceLastLaunchOrderId.put(column, value);
                        }
                        if (column.contains(HbaseContainsByRow.LAST_CLICK_CODE)) {
                            resourceLastClickOrderId.put(column, value);
                        }
                        if (column.contains(HbaseContainsByRow.LAST_CONVERT_CODE)) {
                            resourceLastConvertOrderId.put(column, value);
                        }

                        if (column.contains(HbaseContainsByRow.LAST_OPERATING_CODE)) {
                            featureDo.setLastOperatingResource(value);
                        }
                        if (column.contains(HbaseContainsByRow.RESOURCE_ORDER_CODE)) {
                            dayResourceOrderRank.put(column, Long.parseLong(value));
                        }
                        if (column.contains(HbaseContainsByRow.RESOURCE_CHARGE_CODE)) {
                            dayResourceChargeCnt.put(column, Long.parseLong(value));
                        }
                        if (column.contains(HbaseContainsByRow.RESOURCE_CONVERT_CODE)) {
                            dayResourceConvertCnt.put(column, Long.parseLong(value));
                        }
                }

            }

            featureDo.setDayResourceOrderRank(dayResourceOrderRank);
            featureDo.setDayResourceChargeCnt(dayResourceChargeCnt);
            featureDo.setDayResourceConvertCnt(dayResourceConvertCnt);
            featureDo.setResourceLastGmtCreateTime(resourceLastGmtCreateTime);
            featureDo.setResourceLastLaunchOrderId(resourceLastLaunchOrderId);
            featureDo.setResourceLastClickOrderId(resourceLastClickOrderId);
            featureDo.setResourceLastConvertOrderId(resourceLastConvertOrderId);

            return null;
        });

    }
}
