/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.common.cache;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class RedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtil.class);
    private RedisTemplate<Serializable, Object> redisTemplate;

    public boolean set(String key, Object value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception e) {
            logger.warn("set object  happened error:{}", (Throwable)e);
        }
        return result;
    }

    public boolean setList(String key, Object list, Long expireTime) {
        boolean result = false;
        try {
            String value = JSON.toJSONString((Object)list);
            if (key != null) {
                result = this.set(key, value, expireTime);
            }
        }
        catch (Exception e) {
            logger.warn("setList happened error:{}", (Throwable)e);
        }
        return result;
    }

    public <T> List<T> getList(String key, Class clazz) {
        List result = null;
        try {
            Object value = this.get(key);
            result = JSON.parseArray((String)((String)value), (Class)clazz);
        }
        catch (Exception e) {
            logger.warn("getList happened error:{},key:{}", (Object)e, (Object)key);
        }
        return result;
    }

    public void setRedisTemplate(RedisTemplate<Serializable, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Object get(String key) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        return operations.get((Object)key);
    }

    public <T> T get(String key, Class clazz) {
        Object result = null;
        Object value = this.get(key);
        if (value != null) {
            result = JSON.parseObject((String)((String)value), (Class)clazz);
        }
        return (T)result;
    }

    public boolean set(String key, Object value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            result = true;
        }
        catch (Exception e) {
            logger.error("set happened error:{}", (Throwable)e);
        }
        return result;
    }
}

