/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.deploy.interceptor;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class RecommendInterceptor
implements HandlerInterceptor,
ApplicationContextAware {
    private static final Logger RECOMMEND_LOGGER = LoggerFactory.getLogger(RecommendInterceptor.class);
    private static final Logger SYS_LOGGER = LoggerFactory.getLogger(HandlerInterceptor.class);
    private static final String timePattern = "yyyyMMddHHmmss";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final Set<String> ALLOW_LOG_ENVIROMENT = Sets.newHashSet((Object[])new String[]{"dev", "prod"});
    private boolean limit = false;
    private static final RateLimiter RATE_LIMITER = RateLimiter.create((double)0.02);

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        try {
            DBTimeProfile.enter((String)"afterCompletion");
            String servletPath = httpServletRequest.getServletPath();
            if (this.limit && RATE_LIMITER.tryAcquire() && StringUtils.isNotBlank((String)servletPath)) {
                Object attribute = httpServletRequest.getAttribute("Http-Req-Attr-Rpc-Args");
                if (!(attribute instanceof List)) {
                    return;
                }
                List params = (List)attribute;
                if (params.size() == 2) {
                    Splitter splitter = Splitter.on((String)"/");
                    Iterable split = splitter.omitEmptyStrings().trimResults().split((CharSequence)servletPath);
                    ArrayList<String> strings = new ArrayList<String>();
                    for (String s : split) {
                        strings.add(s);
                    }
                    if (strings.size() == 2) {
                        String strategyId = (String)params.get(1);
                        String service = (String)strings.get(0);
                        String method = (String)strings.get(1);
                        JSONObject json = (JSONObject)JSON.toJSON(params.get(0));
                        json.put("strategyId", (Object)strategyId);
                        json.put("method", (Object)method);
                        json.put("service", (Object)service);
                        json.put("time", (Object)LocalDateTime.now().format(dateTimeFormatter));
                        String record = json.toString();
                        Cat.logMetricForCount((String)"RecommendInterceptor");
                        RECOMMEND_LOGGER.info(record);
                    }
                }
            }
        }
        catch (Exception ee) {
            SYS_LOGGER.info("recommend interceptor error ", (Throwable)ee);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        String active = applicationContext.getEnvironment().getProperty("spring.profiles.active");
        if (ALLOW_LOG_ENVIROMENT.contains(active)) {
            this.limit = true;
        }
    }
}

