package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsActivityIntegrationDto;
import cn.com.duiba.odps.center.api.dto.OdpsActivityRemainDto;
import cn.com.duiba.odps.center.api.dto.OdpsActivitySuerveyDto;
import cn.com.duiba.odps.center.api.dto.OdpsBrickWorkerDto;

import java.util.Date;

/**
 * @author JunAngLiu
 * @Title: ActDataTemplateService
 * @Description: 活动数据模板
 * @date 2018/12/290:55
 */
@AdvancedFeignClient
public interface RemoteActDataTemplateService {


    /**
     * 获取活动 概况数据
     *@param actType 活动类型
     */

    Page<OdpsActivitySuerveyDto> queryPageByConditions( Long activityId,  Long appId, Date startDay,
                                                        Date endDay, int  pageNo,int pageSize,Integer actType);



    /**
     * 获取活动 明细数据
     *@param actType 活动类型
     */

    Page<OdpsActivityIntegrationDto>  queryDetailPageByConditions( Long activityId,  Long appId,  Date startDay,
                                                                  Date endDay,Integer type,int  pageNo, int pageSize,Integer actType);


    /**
     * 获取活动留存
     * @param activityId
     * @param appId
     * @param startDay
     * @param endDay
     * @param type  1 标识 访问留存，2标识 参与留存
     * @param pageNo
     * @param pageSize
     * @param actType 活动类型
     * @return
     */
    Page<OdpsActivityRemainDto> queryPageRemainByconditions(Long activityId,  Long appId,  Date startDay,
                                                            Date endDay,Integer type,int  pageNo, int pageSize,Integer actType);



    /**
     * 获取搬砖工活动数据
     * @param activityId
     * @param appId
     * @param startDay
     * @param endDay
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<OdpsBrickWorkerDto> queryPageBrickWorker(Long activityId, Long appId, Date startDay,
                                                  Date endDay, int  pageNo, int pageSize);


}
