package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsAppItemSalesStatDto;

import java.util.Date;
import java.util.List;


@AdvancedFeignClient
public interface RemoteOdpsAppItemSalesStatService {
    /**
     * 根据日期和开发者商品id列表查询
     *
     * @param day
     * @param appItemIds
     * @return
     */
    List<OdpsAppItemSalesStatDto> findDailyByAppItemIds(Date day, List<Long> appItemIds);

    /**
     * 根据日期和兑吧商品id列表查询
     *
     * @param day
     * @param appId
     * @param itemIds
     * @return
     */
    List<OdpsAppItemSalesStatDto> findDailyByItemIds(Date day, Long appId, List<Long> itemIds);

    /**
     * 取最近一天的商品
     * 1.暂时是海底捞定制使用,web需要加缓存
     * 2.查询频率超过100次,请和DBA沟通
     */
    OdpsAppItemSalesStatDto findLastDayByAppItemId(Long appItemId);
}
