package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.singledog.OdpsDuibaAppActivityDayDIDto;
import cn.com.duiba.odps.center.api.dto.singledog.OdpsDuibaAppActivityHourDIDto;
import cn.com.duiba.odps.center.api.dto.singledog.OdpsDuibaChannelDayDIDto;
import cn.com.duiba.odps.center.api.dto.singledog.OdpsDuibaChannelHourDIDto;

import java.util.Date;
import java.util.List;

/**
 * @Author: lufeng
 * @Description:针对B612单身狗活动 实时数据需求
 * @Date: Created in 2018/11/5
 */
@AdvancedFeignClient
public interface RemoteOdpsReportDataService {

    //获取活动按小时统计数据
    List<OdpsDuibaAppActivityHourDIDto> getOdpsDuibaAppActivityHour(Date date, Long appId, Long activityId);

    //获取活动按日统计数据
    List<OdpsDuibaAppActivityDayDIDto> getOdpsDuibaAppActivityDay(Date date, Long appId, Long activityId);

    //获取活动渠道按小时统计数据
    List<OdpsDuibaChannelHourDIDto> getOdpsDuibaChannelHour(Date date, Long appId, Long activityId);

    //获取活动渠道按日统计数据
    List<OdpsDuibaChannelDayDIDto> getOdpsDuibaChannelDay(Date date, Long appId, Long activityId);

}
