package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsTrafficIndicatorDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2018/12/18 10:52
 */
@AdvancedFeignClient
public interface RemoteOdpsTrafficIndicatorService {

    /**
     * 根据应用和时间查询流量运营数据
     * 不传时间，默认返回最近一个月数据
     *
     * @param appId 应用ID
     * @param day   统计日期 yyyy-MM-dd
     * @return 流量运营数据
     */
    List<OdpsTrafficIndicatorDto> getTrafficIndicator(Long appId, String day);

}
