package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsAppDailyReportDto;

import java.util.List;

/**
 * Created by gey on 18/01/03.
 * 查询月数据
 */
@AdvancedFeignClient
public interface RemoteOdpsAppDailyReportService {
    /**
     * 查询月数据
     * @param appId
     * @param month
     * @return
     */
    public List<OdpsAppDailyReportDto> findAppDailyReportByMonth(Long appId, String month);

    /**
     * 查询月数据 汇总
     * @param appId
     * @param month
     * @return
     */
    public OdpsAppDailyReportDto findSumAppDailyReportByMonth(Long appId,String month);

    /**
     * 根据App和时间区间查询
     * @param appId
     * @param start
     * @param end
     * @return
     */
    public List<OdpsAppDailyReportDto> findAppDailyReportByAppIdAndDay(Long appId, String start, String end);

    /**
     * 根据App和时间区间查询
     * @param appId
     * @param searchDate
     * @return
     */
    public OdpsAppDailyReportDto findByAppIdAndDay(Long appId, String searchDate);
}