package cn.com.duiba.odps.center.api.dto.genie;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author luochi
 * @Date 2019/8/5
 */
public class GenieChartDto implements Serializable {

    private static final long serialVersionUID = 8535818617098404517L;
    /**
     * 主键
     **/
    private Long id;
    /**
     * 图标名称
     **/
    private String chartName;
    /**
     * 图表创建者id
     **/
    private Long adminId;
    /**
     * 图表创建者姓名
     **/
    private String adminName;
    /**
     * 图表类型。1：折线图；2：柱状图；3：饼图；4：核心数据列表；5：热力图；6：数据列表；
     **/
    private Integer chartType;
    /**
     * 时间控件状态。0：关闭；1：开启
     **/
    private Boolean timeControlState;
    /**
     * 搜索控件状态。0：关闭；1：开启（暂时列表类型专属）
     **/
    private Boolean searchControlState;
    /**
     * json格式，搜索指标与对应的别名
     **/
    private String searchTarget;
    /**
     * 维度，取自选定的数据表字段（X轴,列表类型没有）
     **/
    private String dimension;
    /**
     * 时间字段
     **/
    private String timeCondition;
    /**
     * 默认展示天数(不超过365天)
     **/
    private Integer defaultTimeSpan;
    /**
     * 筛选最大时间间隔（不超过365天）
     **/
    private Integer maxTimeSpan;
    /**
     * 删除标志位。0：正常 ；1：删除
     **/
    private Boolean deleted;



    /**
     * 数据创建时间
     **/
    private Date gmtCreate;


    private Integer deliveryState;
    /**
     * 数据修改时间
     **/
    private Date gmtModified;

    /**
     * 指标描述
     **/
    private String targetDescription;
    /**
     * 指标描述开关
     **/
    private Boolean targetDescriptionState;

    /**
     * 指标单位，指标卡专有
     **/
    private String targetUnit;

    public String getTargetUnit() {
        return targetUnit;
    }

    public void setTargetUnit(String targetUnit) {
        this.targetUnit = targetUnit;
    }

    public String getTargetDescription() {
        return targetDescription;
    }

    public void setTargetDescription(String targetDescription) {
        this.targetDescription = targetDescription;
    }

    public Boolean getTargetDescriptionState() {
        return targetDescriptionState;
    }

    public void setTargetDescriptionState(Boolean targetDescriptionState) {
        this.targetDescriptionState = targetDescriptionState;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getChartName() {
        return chartName;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public Integer getChartType() {
        return chartType;
    }

    public void setChartType(Integer chartType) {
        this.chartType = chartType;
    }

    public Boolean getTimeControlState() {
        return timeControlState;
    }

    public void setTimeControlState(Boolean timeControlState) {
        this.timeControlState = timeControlState;
    }

    public Boolean getSearchControlState() {
        return searchControlState;
    }

    public void setSearchControlState(Boolean searchControlState) {
        this.searchControlState = searchControlState;
    }

    public String getSearchTarget() {
        return searchTarget;
    }

    public void setSearchTarget(String searchTarget) {
        this.searchTarget = searchTarget;
    }

    public String getDimension() {
        return dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getTimeCondition() {
        return timeCondition;
    }

    public void setTimeCondition(String timeCondition) {
        this.timeCondition = timeCondition;
    }

    public Integer getDefaultTimeSpan() {
        return defaultTimeSpan;
    }

    public void setDefaultTimeSpan(Integer defaultTimeSpan) {
        this.defaultTimeSpan = defaultTimeSpan;
    }

    public Integer getMaxTimeSpan() {
        return maxTimeSpan;
    }

    public void setMaxTimeSpan(Integer maxTimeSpan) {
        this.maxTimeSpan = maxTimeSpan;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getDeliveryState() {
        return deliveryState;
    }

    public void setDeliveryState(Integer deliveryState) {
        this.deliveryState = deliveryState;
    }

    @Override
    public String toString() {
        return "GenieChartDto{" +
                "id=" + id +
                ", chartName='" + chartName + '\'' +
                ", adminId=" + adminId +
                ", adminName='" + adminName + '\'' +
                ", chartType=" + chartType +
                ", timeControlState=" + timeControlState +
                ", searchControlState=" + searchControlState +
                ", JsonSearchTargetDto='" + searchTarget + '\'' +
                ", dimension='" + dimension + '\'' +
                ", timeCondition='" + timeCondition + '\'' +
                ", defaultTimeSpan=" + defaultTimeSpan +
                ", maxTimeSpan=" + maxTimeSpan +
                ", deleted=" + deleted +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                '}';
    }




}
