package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsExchangeIndicatorDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2018/12/18 10:52
 */
@AdvancedFeignClient
public interface RemoteOdpsExchangeIndicatorService {

    /**
     * 根据应用和时间查询商品兑换数据
     *
     * @param appId  应用ID
     * @param day    统计日期 yyyy-MM-dd
     * @param appItemId 商品ID
     * @param offset 分页起始值
     * @param max    每页最大值 默认100
     * @return 商品兑换数据
     */
    List<OdpsExchangeIndicatorDto> getExchangeIndicatorPage(Long appId, String day, Long appItemId, Integer offset, Integer max);
}
