package cn.com.duiba.odps.center.api.param;

import java.io.Serializable;
import java.util.Date;

/**
 * 复盘数据配置分页查询参数
 * @Author: xuwei
 * @Date: 2020/3/25 17:47
 */
public class DataCheckPageQueries implements Serializable {

    private static final long serialVersionUID = 7677210839496094377L;

    /**
     * 页码
     */
    private int page;
    /**
     * 数量
     */
    private int pageSize;
    /**
     * 开始时间
     */
    private Date fromDate;
    /**
     * 结束时间
     */
    private Date toDate;
    /**
     * 开发者应用ID
     */
    private Long appId;
    /**
     * 开发者应用名称
     */
    private String appName;
    /**
     * 标题
     */
    private String title;
    /**
     * 类型
     */
    private Integer type;

    /**
     * 创建人
     */
    private String createName;

    /**
     * 是否查询page_json字段
     */
    private boolean includePageJson;

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Date getFromDate() {
        return fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public boolean getIncludePageJson() {
        return includePageJson;
    }

    public void setIncludePageJson(boolean includePageJson) {
        this.includePageJson = includePageJson;
    }

    public int getStartPage() {
        return (page - 1) * pageSize;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
}
