package cn.com.duiba.odps.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @author JunAngLiu
 * @Title: OdpsActivityIntegrationDto
 * @Description: 活动明细数据
 * @date 2018/12/290:16
 */
public class OdpsActivityIntegrationDto implements Serializable {

    private static final long serialVersionUID = 1772675233716182160L;
    /**
     * 日期
     */
    private Date curDate;

    /**
     * 总预算
     */
    private Long totalBudget;

    /**
     * 已发放总额
     */
    private Long totalGrantAmount;

    /**
     * 分享发放额度
     */
    private Long shareGrantAmount;

    /**
     * 邀请发放额度
     */
    private Long invitGrantAmount;

    /**
     * 注册发放
     */
    private Long registerGrantAmount;

    /**
     * 发放类型 0 红包，1 积分
     */
    private Boolean grantType;

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getTotalBudget() {
        return totalBudget;
    }

    public void setTotalBudget(Long totalBudget) {
        this.totalBudget = totalBudget;
    }

    public Long getTotalGrantAmount() {
        return totalGrantAmount;
    }

    public void setTotalGrantAmount(Long totalGrantAmount) {
        this.totalGrantAmount = totalGrantAmount;
    }

    public Long getShareGrantAmount() {
        return shareGrantAmount;
    }

    public void setShareGrantAmount(Long shareGrantAmount) {
        this.shareGrantAmount = shareGrantAmount;
    }

    public Long getInvitGrantAmount() {
        return invitGrantAmount;
    }

    public void setInvitGrantAmount(Long invitGrantAmount) {
        this.invitGrantAmount = invitGrantAmount;
    }

    public Long getRegisterGrantAmount() {
        return registerGrantAmount;
    }

    public void setRegisterGrantAmount(Long registerGrantAmount) {
        this.registerGrantAmount = registerGrantAmount;
    }

    public Boolean getGrantType() {
        return grantType;
    }

    public void setGrantType(Boolean grantType) {
        this.grantType = grantType;
    }
}
