package cn.com.duiba.odps.center.api.enums.genie;

import org.apache.commons.lang.StringUtils;

/**
 * @author haojiahong
 * @date 2020-09-09
 */
public enum SumRealTimeTargetEnum {
    ACCESS_UV("accessUv", "访问UV", 1),
    JOIN_UV("joinUv", "参与UV", 2),
    SHARE_UV("shareUv", "分享UV", 3),
    INVITE_UV("inviteUv", "邀请UV", 4),
    HELP_UV("helpUv", "助力UV", 5),
    RECALL_UV("recallUv", "召回访问UV", 6),
    SUM_PRIZE("sumPrize", "中奖人数", 7),
    SUM_PRIZE_DRAW("sumPrizeDraw", "领奖人数", 8),

    ;
    private String targetName;
    private String targetAlias;
    private Integer targetSequence;

    SumRealTimeTargetEnum(String targetName, String targetAlias, Integer targetSequence) {
        this.targetName = targetName;
        this.targetAlias = targetAlias;
        this.targetSequence = targetSequence;
    }

    public String getTargetName() {
        return targetName;
    }

    public String getTargetAlias() {
        return targetAlias;
    }

    public Integer getTargetSequence() {
        return targetSequence;
    }

    public static SumRealTimeTargetEnum getByTargetName(String targetName) {
        for (SumRealTimeTargetEnum value : SumRealTimeTargetEnum.values()) {
            if (StringUtils.equals(targetName, value.getTargetName())) {
                return value;
            }
        }
        return null;
    }

}
