package cn.com.duiba.odps.center.api.param;

import java.io.Serializable;
import java.util.Date;

/**
 * @author XuJing
 * @since 2020/9/21 2:10 下午
 */
public class AilaiyiActivityToolParam implements Serializable {

	private static final long serialVersionUID = -301986138316030477L;
	private Long appId;

	private Integer dataType;

	private Date startDay;

	private Date endDay;

	private Integer page;

	private Integer pageSize;

	private Integer offSet;

	public AilaiyiActivityToolParam() {
	}

	public AilaiyiActivityToolParam(Long appId, Integer dataType, Date startDay, Date endDay, Integer page, Integer pageSize) {
		this.appId = appId;
		this.dataType = dataType;
		this.startDay = startDay;
		this.endDay = endDay;
		this.page = page;
		this.pageSize = pageSize;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Integer getDataType() {
		return dataType;
	}

	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	public Integer getPage() {
		return page;
	}

	public void setPage(Integer page) {
		this.page = page;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getOffSet() {
		if (null != page && null != pageSize && page > 0 && pageSize > 0) {
			return (page - 1) * pageSize;
		}
		return offSet;
	}

	public void setOffSet(Integer offSet) {
		this.offSet = offSet;
	}

	public Date getStartDay() {
		return startDay;
	}

	public void setStartDay(Date startDay) {
		this.startDay = startDay;
	}

	public Date getEndDay() {
		return endDay;
	}

	public void setEndDay(Date endDay) {
		this.endDay = endDay;
	}
}
