package cn.com.duiba.odps.center.api.param.marketing;

import cn.com.duiba.wolf.utils.DateUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: pengyi
 * @description:
 * @date: 2021/7/16 下午2:21
 */
public class FulcreditsPageParam implements Serializable {

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 活动id
     */
    private Long actId;

    /**
     * 开始时间，默认前七天开始统计
     */
    private Date startDate = DateUtils.getDayStartTime(DateUtils.daysAddOrSub((new Date()),-8));

    /**
     * 结束时间，默认从前一天结束
     */
    private Date endDate = DateUtils.getDayEndTime(DateUtils.daysAddOrSub((new Date()),-1));

    private Integer pageNo = 1;

    private Integer pageSize = 20;

    private Integer offset;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActId() {
        return actId;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        return this.pageSize * (this.pageNo - 1);
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }
}
