package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.BankQuickPayLimitedGoodsDto;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteBankQuickPayLimitedGoodsService {
    /**
     * 获取银行快捷支付商品兑换数据
     * @return
     */
    List<BankQuickPayLimitedGoodsDto> findAllByCondition(Long appId, Long actId,
                                                         Date startDate, Date endDate);
    /**
     * 分页获取银行快捷支付兑换商品数据
     * @return
     */
    Page<BankQuickPayLimitedGoodsDto> find4Page(Long appId, Long actId,
                                                Date startDate, Date endDate,
                                                int pageNo, int pageSize);
}
