package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsIqiyiInHourDiDto;
import cn.com.duiba.odps.center.api.dto.OdpsIqiyiOutHourDiDto;

import java.util.Date;
import java.util.List;

/**
 * @Description: (2018）爱奇艺年终数据需求-实时数据报表（端外&端内）
 * @Author: fxr
 * @Date: 2019/1/4
 */
@AdvancedFeignClient
public interface RemoteOdpsIqiyiReportDataService {

    /**
     * 获取端内按日期统计的实时数据
     * @param date
     * @return
     */
    List<OdpsIqiyiInHourDiDto> getOdpsIqiyiInHourDiByDate(Date date);

    /**
     * 获取端外按日期统计的实时数据
     * @param date
     * @return
     */
    List<OdpsIqiyiOutHourDiDto> getOdpsIqiyiOutHourDiBydate(Date date);
}
