package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.risk.PrizeGrantWarnDataDto;
import cn.com.duiba.odps.center.api.dto.risk.PrizeGrantWarnParam;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemotePrizeGrantWarnService
 * @Description: 奖品发放预警所需数据
 * @date 2019/5/414:51
 */
@AdvancedFeignClient
public interface RemotePrizeGrantWarnDataService {
    //统计数量
    int countByCondition(PrizeGrantWarnParam param);

    //条件查询list
    List<PrizeGrantWarnDataDto> queryListByCondition(PrizeGrantWarnParam param);


    //统计数量（按照每天一条数据统计 总量）
    int countTotalOnDay(PrizeGrantWarnParam param);

    //条件查询list（按照每天一条数据统计 总量）
    List<PrizeGrantWarnDataDto> queryTotalListOnDay(PrizeGrantWarnParam param);
}
