package cn.com.duiba.odps.center.api.remoteservice.datacheck;


import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.datacheck.CreditsDistributionNewDto;
import cn.com.duiba.odps.center.api.dto.datacheck.DataCheckActivityConsumePointTop5Dto;
import cn.com.duiba.odps.center.api.dto.datacheck.DataCheckConversionRateTop5Dto;
import cn.com.duiba.odps.center.api.dto.datacheck.DataCheckEverydayDataDto;
import cn.com.duiba.odps.center.api.dto.datacheck.DataCheckGoodsConsumePointTop5Dto;
import cn.com.duiba.odps.center.api.dto.datacheck.DataCheckInfoDto;
import cn.com.duiba.odps.center.api.dto.datacheck.DataCheckMonthlyDataDto;
import cn.com.duiba.odps.center.api.dto.datacheck.DmCreditsConsumeDataDto;
import cn.com.duiba.odps.center.api.dto.datacheck.DmItemCreditsConsumeDataDto;
import cn.com.duiba.odps.center.api.dto.datacheck.DmSignInDataDto;
import cn.com.duiba.odps.center.api.dto.datacheck.ProjectxActivityRemainDiDto;
import cn.com.duiba.odps.center.api.dto.datacheck.ProjectxTotalReviewDiDto;
import cn.com.duiba.odps.center.api.dto.datacheck.TotalProjectxActivityDiDto;
import cn.com.duiba.odps.center.api.param.DataCheckPageQueries;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 数据复盘基本信息表 前端控制器
 * </p>
 *
 * @author XuJing
 * @since 2020-03-03
 */
@AdvancedFeignClient
public interface RemoteDataCheckInfoService {
    /**
     * 查询列表<br>
     * 已废弃，请用{@link #listModelWithQueries(DataCheckPageQueries)}方法代替
     * @param page     页码
     * @param pageSize 每页大小
     * @param fromDate 开始时间
     * @param toDate   结束时间
     * @param appId    应用id
     * @param appName  应用名称
     * @param title    标题
     * @return
     */
    @Deprecated
    Page<DataCheckInfoDto> listModelByPage(Integer page, Integer pageSize, Date fromDate, Date toDate, Long appId, String appName, String title);

    /**
     * @param queries 查询参数
     * @return
     */
    Page<DataCheckInfoDto> listModelWithQueries(DataCheckPageQueries queries);

    /**
     * @param id 记录id
     * @return
     */
    DataCheckInfoDto find(Long id);

    /**
     * 保存或者更新模板和pdf
     *
     * @param checkInfoDto
     * @return
     */
    Long saveOrUpdate(DataCheckInfoDto checkInfoDto);

    /**
     * 查询活动积分消耗top5
     *
     * @param dateTime
     * @param appId
     * @return
     */
    List<DataCheckActivityConsumePointTop5Dto> findActivityConsumePointTop5ByDateTimeAndAppId(String dateTime, Long appId);


    /**
     * 查询商品转化率top5
     *
     * @param dateTime
     * @param appId
     * @return
     */
    List<DataCheckConversionRateTop5Dto> findDataCheckConversionRateTop5ByDateTimeAndAppId(String dateTime, Long appId);

    /**
     * 查询每日数据列表
     *
     * @param dateTime
     * @param appId
     * @return
     */
    List<DataCheckEverydayDataDto> findDataCheckEverydayDataByDateTimeAndAppId(String dateTime, Long appId);

    /**
     * 查询商品积分消耗top5
     *
     * @param dateTime
     * @param appId
     * @return
     */
    List<DataCheckGoodsConsumePointTop5Dto> findDataCheckGoodsConsumePointTop5ByDateTimeAndAppId(String dateTime, Long appId);

    /**
     * 查询月度数据
     *
     * @param dateTime
     * @param appId
     * @return
     */
    DataCheckMonthlyDataDto findDataCheckMonthlyDataByDateTimeAndAppId(String dateTime, Long appId);

    /**
     * 查询积分分布
     *
     * @param dateTime
     * @param appId
     * @return
     */
    List<CreditsDistributionNewDto> findDataCheckPointDistributionByDateTimeAndAppId(String dateTime, Long appId);

    /**
     * 获取数据总表最新数据
     *
     * @param appId
     * @param projectId
     * @return
     */
    ProjectxTotalReviewDiDto findDataByTime(Long appId, String projectId, Date startTime, Date endTime);

    /**
     * 根据时间获取活动数据明细
     *
     * @param appId
     * @param projectId
     * @param startTime
     * @param endTime
     * @return
     */
    List<TotalProjectxActivityDiDto> listActivityDiDataByTime(Long appId, String projectId, Date startTime, Date endTime);

    /**
     * 根据时间获取活动留存明细
     *
     * @param appId
     * @param projectId
     * @param startTime
     * @param endTime
     * @return
     */
    List<ProjectxActivityRemainDiDto> listRemainDiDataByTime(Long appId, String projectId, Date startTime, Date endTime);
    /**
     * 根据ID删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 根据时间获取积分消耗情况
     * @param dateTime
     * @param appId
     * @return
     */
    List<DmCreditsConsumeDataDto> listCreditsConsumeDataByTime(String dateTime, Long appId);

    /**
     * 根据时间获取商品积分消耗情况
     * @param dateTime
     * @param appId
     * @return
     */
    List<DmItemCreditsConsumeDataDto> listItemCreditsConsumeDataByTime(String dateTime, Long appId);

    /**
     * 根据时间获取签到数据
     * @param dateTime
     * @param appId
     * @return
     */
    List<DmSignInDataDto> listSignInfoDataByTime(String dateTime, Long appId);

}
