package cn.com.duiba.odps.center.api.remoteservice.yearreview;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.yearreview.ActStatCollectDto;
import cn.com.duiba.odps.center.api.dto.yearreview.ActStatSignCollectDto;
import cn.com.duiba.odps.center.api.dto.yearreview.ActStatSignTopDto;
import cn.com.duiba.odps.center.api.dto.yearreview.ActStatTopDto;
import cn.com.duiba.odps.center.api.dto.yearreview.ActStatVisitDto;

import java.util.Date;
import java.util.List;

/**
 * @author haojiahong
 * @date 2022-05-10
 */
@AdvancedFeignClient
public interface RemoteActStatService {

    /**
     * 活动数据情况
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    ActStatVisitDto getVisitData(Long appId, Date startTime, Date endTime);


    /**
     * 活动数据情况-补给站活动top
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    List<ActStatTopDto> duibaTop(Long appId, Date startTime, Date endTime);

    /**
     * 活动数据情况-补给站活动top-汇总文案
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    ActStatCollectDto duibaCollect(Long appId, Date startTime, Date endTime);

    /**
     * 活动数据情况-活动工具top
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    List<ActStatTopDto> appTop(Long appId, Date startTime, Date endTime);

    /**
     * 活动数据情况-活动工具top-汇总文案
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    ActStatCollectDto appCollect(Long appId, Date startTime, Date endTime);

    /**
     * 活动数据情况-签到活动top
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    List<ActStatSignTopDto> signTop(Long appId, Date startTime, Date endTime);

    /**
     * 活动数据情况-签到活动top-汇总文案
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    ActStatSignCollectDto signCollect(Long appId, Date startTime, Date endTime);

}
