package cn.com.duiba.odps.center.api.remoteservice.yearreview;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.yearreview.ActiveDataPerformanceDto;
import cn.com.duiba.odps.center.api.dto.yearreview.ActivePerformanceDto;
import cn.com.duiba.odps.center.api.dto.yearreview.BaseQueryDto;
import cn.com.duiba.odps.center.api.dto.yearreview.CreditsConsumePerformanceDto;
import cn.com.duiba.odps.center.api.dto.yearreview.MonthDataDto;
import cn.com.duiba.odps.center.api.dto.yearreview.TendencyChartDto;

import java.util.List;

/**
 * Created by zhangyongjie on 2022/5/12 1:41 下午
 */
@AdvancedFeignClient
public interface RemoteGeneralStaticService {

    /**
     * 查询活跃数据
     * @param queryDto
     * @return
     */
    ActiveDataPerformanceDto queryActiveData(BaseQueryDto queryDto) throws Exception;


    /**
     * 查询积分消耗数据
     * @param queryDto
     * @return
     * @throws Exception
     */
    CreditsConsumePerformanceDto queryCreditsConsumeData(BaseQueryDto queryDto) throws Exception;

    /**
     * 查询趋势图
     * @param queryDto
     * @return
     * @throws Exception
     */
    TendencyChartDto queryTendencyChart(BaseQueryDto queryDto) throws Exception;

    /**
     * 查询月度数据概况
     * @param queryDto
     * @return
     * @throws Exception
     */
    List<MonthDataDto> queryMonthData(BaseQueryDto queryDto) throws Exception;


    /**
     * 查询活跃数据表现
     * @param queryDto
     * @return
     * @throws Exception
     */
    ActivePerformanceDto  queryActivePerformance(BaseQueryDto queryDto) throws Exception;
}
