package cn.com.duiba.odps.center.api.remoteservice.yearreview;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.yearreview.BaseQueryDto;
import cn.com.duiba.odps.center.api.dto.yearreview.CarryCreditsDto;
import cn.com.duiba.odps.center.api.dto.yearreview.RemainDataDto;
import cn.com.duiba.odps.center.api.dto.yearreview.RemainTendencyChartDto;

import java.util.List;

/**
 * Created by zhangyongjie on 2022/5/17 5:04 下午
 * 留存数据
 */
@AdvancedFeignClient
public interface RemoteRemainDataService {

    /**
     * 查询留存数据
     * @param queryDto
     * @return
     */
    RemainDataDto  queryRemainData(BaseQueryDto queryDto) throws Exception;

    /**
     * 查询留存趋势图
     * @param queryDto
     * @return
     * @throws Exception
     */
    List<RemainTendencyChartDto> queryRemainTendencyChart(BaseQueryDto queryDto) throws Exception;


    /**
     * 查询积分携带情况
     * @param queryDto
     * @return
     * @throws Exception
     */
    CarryCreditsDto queryCreditsCarryData(BaseQueryDto queryDto) throws Exception;

}
