package cn.com.duiba.odps.center.api.remoteservice.fjboc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.fjboc.BankOfFujianBocDiDto;
import cn.com.duiba.odps.center.api.dto.fjboc.FujianBocConsumerParticipateDto;
import cn.com.duiba.odps.center.api.dto.fjboc.FujianBocIncrementalDiDto;
import cn.com.duiba.odps.center.api.dto.fjboc.FujianBocIntegralTaskDetailDiDto;
import cn.com.duiba.odps.center.api.dto.fjboc.FujianBocYearMonthDiDto;

import java.util.Date;
import java.util.List;

/**
 * @author chenzhenxing
 * @date 2022/1/24 4:14 下午
 */
@AdvancedFeignClient
public interface RemoteOdpsFjBocDataService {

    List<BankOfFujianBocDiDto> getFujianBocDataByDate(Date startDate, Date endDate);

    List<FujianBocIncrementalDiDto> getFjBocIncrementalData(Date date);

    List<FujianBocIntegralTaskDetailDiDto> getFjBocIntegralTaskData(List<Long> cidList, Date date);

    List<FujianBocYearMonthDiDto> getFjBocYearMonthData(List<Long> cidList, Date date);

    List<FujianBocConsumerParticipateDto> getConsumerParticipateDataByDate(Date date);

}
