package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.odps.center.api.dto.OdpsActivityDailyStatDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by gey on 18/01/03.
 * 每日活动统计
 */
@AdvancedFeignClient
public interface RemoteOdpsActivityDailyStatService {
    /**
     * 根据appId和开始日期，结束日期，查询
     */
    public List<OdpsActivityDailyStatDto> findSumByAppIdAndDayBetween(Long appId, Date startDay, Date endDay);

    /**
     * 根据运营活动ids查询
     */
    public List<DeveloperActivityStatisticsDto> findAllByOperatingActivityIds(List<Long> activityIds);

    public List<OdpsActivityDailyStatDto> findActivityDailyStatByActivityIdAndType(Long activityId, Integer relationType, Integer offset, Integer max);

    public Long findActivityDailyStatByActivityIdAndTypeCount(Long activityId, Integer relationType);

	/**
	 * 根据运营活动id查询全部订单数
	 *
	 * @param activityIds 运营活动id列表
	 * @return Map  key-运营活动id，value-全部订单数量
	 */
	Map<Long, Long> findAllOrderCountByOperatingActivityIds(List<Long> activityIds);
}