package cn.com.duiba.odps.center.api.remoteservice.zjzy.zmjs;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.zjzy.zmjs.ZmjsCoinStatDto;
import cn.com.duiba.odps.center.api.dto.zjzy.zmjs.ZmjsJoinStatDto;
import cn.com.duiba.odps.center.api.dto.zjzy.zmjs.ZmjsLevelStatDto;
import cn.com.duiba.odps.center.api.dto.zjzy.zmjs.ZmjsOverviewStatDto;

import java.util.Date;
import java.util.List;

/**
 * 浙江中烟-最美江山活动-数据大屏
 *
 * @author haojiahong
 * @date 2020-11-11
 */
@AdvancedFeignClient
public interface RemoteZjzyZmjsQueryStatService {

    /**
     * 大盘指标数据统计
     *
     * @param appId       应用id
     * @param activityId  活动id，星速台项目id（十进制）
     * @param prizeIdList 奖品id
     * @return
     */
    ZmjsOverviewStatDto getOverviewStat(Long appId, Long activityId, List<String> prizeIdList);

    /**
     * 活动关卡数据统计
     *
     * @param appId      应用id
     * @param activityId 活动id，星速台项目id（十进制）
     * @return
     */
    List<ZmjsLevelStatDto> getLevelStat(Long appId, Long activityId);

    /**
     * 活动金币数据统计
     *
     * @param appId      应用id
     * @param activityId 活动id，星速台项目id（十进制）
     * @return
     */
    List<ZmjsCoinStatDto> getCoinStat(Long appId, Long activityId);


    /**
     * 每日参与人数统计
     *
     * @param startTime 活动开始时间
     * @param endTime   活动结束时间
     * @return
     */
    List<ZmjsJoinStatDto> getJoinStat(Date startTime, Date endTime);
}
