package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsMainOrderDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2018/12/18 10:52
 */
@AdvancedFeignClient
public interface RemoteOdpsMainOrderService {

    /**
     * 根据应用和时间查询主订单数据
     *
     * @param appId  应用ID
     * @param day    统计日期 yyyy-MM-dd
     * @param offset 分页起始值
     * @param max    每页最大值 默认100
     * @return 商品兑换数据
     */
    List<OdpsMainOrderDto> getMainOrderPage(Long appId, String day, Integer offset, Integer max);

}
