package cn.com.duiba.odps.center.api.remoteservice.yearreview;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.yearreview.OrderStatTypeDto;
import cn.com.duiba.odps.center.api.dto.yearreview.OrderStatVisitDto;

import java.util.Date;

/**
 * @author haojiahong
 * @date 2022-05-10
 */
@AdvancedFeignClient
public interface RemoteOrderStatService {

    /**
     * 订单数据情况
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    OrderStatVisitDto getVisitData(Long appId, Date startTime, Date endTime);


    /**
     * 订单数据情况-订单类型
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    OrderStatTypeDto getTypeData(Long appId, Date startTime, Date endTime);
}
