package cn.com.duiba.odps.center.api.remoteservice.houjian;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.houjian.CoreStatisticsDto;
import cn.com.duiba.odps.center.api.dto.houjian.ExchangeDto;
import cn.com.duiba.odps.center.api.dto.houjian.LevelDto;
import cn.com.duiba.odps.center.api.dto.houjian.RetentionRateDto;
import cn.com.duiba.odps.center.api.dto.houjian.TaskDto;

import java.util.List;

/**
 * 厚建养成数据指标查询
 *
 * @author zhuxj
 * @since 2022/6/9
 */
@AdvancedFeignClient
public interface RemoteHouJianStatisticService {

    /**
     * 查询最近一次统计的核心指标数据
     *
     * @return 指标数据
     */
    public CoreStatisticsDto getRecentCoreStatistic();


    /**
     * 查询某个区间的所有指标数据数据
     *
     * @param startDate 开始日期（含）
     * @param endDate   结束日期（含）
     * @return
     */
    public List<CoreStatisticsDto> listStatistic(String startDate, String endDate);

    /**
     * 查询某个区间的所有留存率记录
     *
     * @param startDate 开始日期（含）
     * @param endDate   结束日期（含）
     * @return
     */
    public List<RetentionRateDto> listRetention(String startDate, String endDate);


    /**
     * 查询某个区间的等级分布数据
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public List<LevelDto> listLevel(String startDate, String endDate);

    /**
     * 查询兑换数据
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public List<ExchangeDto> listExchange(String startDate, String endDate);

    /**
     * 查询任务数据
     * @param startDate
     * @param endDate
     * @return
     */
    public List<TaskDto> listTask(String startDate, String endDate);
}
