package cn.com.duiba.odps.center.api.enums.genie;

import org.apache.commons.lang.StringUtils;

/**
 * @author haojiahong
 * @date 2020-09-09
 */
public enum RealTimeTargetEnum {
    ACCESS_PV("accessPv", "访问PV", 1),
    ACCESS_UV("accessUv", "访问UV", 2),
    JOIN_PV("joinPv", "参与PV", 3),
    JOIN_UV("joinUv", "参与UV", 4),
    SHARE_PV("sharePv", "分享PV", 5),
    SHARE_UV("shareUv", "分享UV", 6),
    INVITE_PV("invitePv", "邀请PV", 7),
    INVITE_UV("inviteUv", "邀请UV", 8),
    HELP_PV("helpPv", "助力PV", 9),
    HELP_UV("helpUv", "助力UV", 10),
    RECALL_PV("recallPv", "召回访问PV", 11),
    RECALL_UV("recallUv", "召回访问UV", 12),
    SUM_PRIZE("sumPrize", "中奖人数", 13),
    SUM_PRIZE_DRAW("sumPrizeDraw", "领奖人数", 14),

    ;
    private String targetName;
    private String targetAlias;
    private Integer targetSequence;

    RealTimeTargetEnum(String targetName, String targetAlias, Integer targetSequence) {
        this.targetName = targetName;
        this.targetAlias = targetAlias;
        this.targetSequence = targetSequence;
    }

    public String getTargetName() {
        return targetName;
    }

    public String getTargetAlias() {
        return targetAlias;
    }

    public Integer getTargetSequence() {
        return targetSequence;
    }

    public static RealTimeTargetEnum getByTargetName(String targetName) {
        for (RealTimeTargetEnum value : RealTimeTargetEnum.values()) {
            if (StringUtils.equals(targetName, value.getTargetName())) {
                return value;
            }
        }
        return null;
    }
}
