package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.ActivityExtraDataTemplateDto;

import java.util.Date;
import java.util.List;

/**
 * @author JunAngLiu
 * @Title: ActDataTemplateService
 * @Description: 活动数据模板
 * @date 2018/12/290:55
 */
@AdvancedFeignClient
public interface RemoteActExtraDataTemplateService {


    /**
     * PK获取某个时间段的日期数据
     */
    List<Date> queryCurDateByConditions(Long activityId, Long appId, Date startDay, Date endDay);


    /**
     * 获取详细数据
     * @param activityId
     * @param appId
     * @param startDay
     * @param endDay
     * @return
     */
    List<ActivityExtraDataTemplateDto> queryPageByConditions(Long activityId, Long appId, Date startDay, Date endDay);
}
