package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.BankQuickPayGoodsDto;

import java.util.Date;
import java.util.List;
@AdvancedFeignClient
public interface RemoteBankQuickPayGoodsService {
    /**
     * 获取银行快捷支付商品兑换数据导出
     */
    List<BankQuickPayGoodsDto> selectDataByCondition(Long appId, Long actId,
                                                         Date startDate , Date endDate);
    /**
     * 分页获取银行快捷支付兑换商品数据
     */
    Page<BankQuickPayGoodsDto> selectDataByPage(Long appId, Long actId,
                                                     Date startDate , Date endDate,
                                                     Integer pageNo, Integer pageSize);
}
