package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsCollectCardGrantCardDto;
import cn.com.duiba.odps.center.api.dto.OdpsCollectCardGrantPrizeDto;

import java.util.Date;

/**
 * @author JunAngLiu
 * @Title: RemoteCollectCardService
 * @Description: 集卡活动数据
 * @date 2019/3/817:10
 */
@AdvancedFeignClient
public interface RemoteCollectCardService {


    /**
     * 查询 卡片发放数量数据
     * @param actId
     * @param appId
     * @param startDay
     * @param endDay
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<OdpsCollectCardGrantCardDto> queryPage(Long actId, Long appId, Date startDay, Date endDay,int pageNo,int pageSize);


    /**
     * 查询 奖品发放数量数据
     * @param appId
     * @param actId
     * @param startDay
     * @param endDay
     * @param resource 发奖来源：1 抽奖发放；2集卡兑换
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<OdpsCollectCardGrantPrizeDto> queryByConditions(Long appId, Long actId, Date startDay,
                                                         Date endDay, Integer  resource , int  pageNo, int pageSize);
}
