package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsAppDailyStatDto;

import java.util.Date;
import java.util.List;

/**
 * Created by gey on 18/01/03.
 * 查询周和月的uv
 */
@AdvancedFeignClient
public interface RemoteOdpsAppDailyStatService {
    /**
     *
     * @param appId
     * @param day  yyyyMMdd
     * @return
     */
    public OdpsAppDailyStatDto findStatByAppAtDay(Long appId, String day);

    /**
     * 查询时间区间内的数据，将所有数据累计，返回单条记录
     * 主要用于展示：本周数据，本月数据
     * @param appId
     * @param start
     * @param end
     * @return
     */
    public OdpsAppDailyStatDto findByAppMerge(Long appId, String start, String end);

    /**
     * 查询月数据
     * @param appId
     * @param month
     * @return
     */
    public List<OdpsAppDailyStatDto> findAppDailyStatByMonth(Long appId, String month);

    /**
     * 查询月数据
     * @param appId
     * @param month
     * @return
     */
    public OdpsAppDailyStatDto findSumAppDailyStatByMonth(Long appId,String month);

    /**
     * 根据App和时间区间查询
     */
    public List<OdpsAppDailyStatDto> findStatByAppIdAndDayBetween(Long appId, Date start, Date end);

}
