package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsHappyGroupDto;

import java.util.Date;

/**
 * @Author chenxiangge
 * @Date 2019/3/12
 */
@AdvancedFeignClient
public interface RemoteOdpsHappyGroupService {
    /**
     * 根据活动id appid查询时间范围内拼拼乐数据信息
     * @param actId
     * @param appId
     * @param start
     * @param end
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<OdpsHappyGroupDto> findByActIdAndAppIdDateRange(Long actId, Long appId, Date start, Date end, int pageNo, int pageSize);

    /**
     * 根据活动id appid查询时间范围内拼拼乐数据概况数据信息
     * @param actId
     * @param appId
     * @param start
     * @param end
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<OdpsHappyGroupDto> findActivityOverallByDateRange(Long actId, Long appId, Date start, Date end,int pageNo,int pageSize);
}
