package cn.com.duiba.odps.center.api.remoteservice.data;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiDbdUserActionDto;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiDbdUserRankDto;

import java.util.List;

/**
 * 花呗打病毒活动查询
 *
 */
@AdvancedFeignClient
public interface RemoteHuanbeiDbdDataService {
    /**
     * 获取排行榜前三名用户
     * @return
     */
    List<HuanbeiDbdUserRankDto> findRankData();

    /**
     * 查询用户任务数据
     *
     * @param date
     * @param offset
     * @param size
     * @return
     */
    /**
     *
     * @param date 不填则查询全部数据
     * @param type 0-设置提醒 1-发出邀请
     * @param offset
     * @param size
     * @return
     */
    List<HuanbeiDbdUserActionDto> findDailyUserTaskData(String date, int type, int offset, int size);
}
