package cn.com.duiba.odps.center.api.remoteservice.data;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiLotsDrawingPushDataDTO;
import cn.com.duiba.odps.center.api.param.data.HuanbeiLotsDrawingPushPageQuery;

import java.util.Date;
import java.util.List;

/**
 * 还呗幸运上上签推送服务
 */
@AdvancedFeignClient
public interface RemoteHuanbeiLotsDrawingPushService {

  // ========================== 推送数据接口 ==========================

  /**
   * 分页查询待推送用户T+1数据
   *
   * @param query 分页查询参数
   * @return 待推送用户T+1数据列表
   */
  List<HuanbeiLotsDrawingPushDataDTO> pageQueryPushDataRecords(
    final HuanbeiLotsDrawingPushPageQuery query);

  /**
   * 统计某日待推送记录数量
   *
   * @param date 日期
   * @return 某日待推送记录数量
   */
  int countPushRecordsByDate(final Date date);
}
