package cn.com.duiba.odps.center.api.remoteservice.data;


import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.data.GoodsStatisticParam;
import cn.com.duiba.odps.center.api.dto.data.GoodsStatisticsDto;
import cn.com.duiba.odps.center.api.dto.data.GoodsTransDto;
import cn.com.duiba.odps.center.api.dto.data.OrdersStatisticsDto;

import java.util.Date;
import java.util.List;

/**
 * @author 刘凯
 * @Description: 应用纬度订单统计
 * @date 2019/5/09:55
 */
@AdvancedFeignClient
public interface RemoteGoodsStatisticsService {



    /**
     * @Description: 根据指定日期查询
     */
    List<GoodsStatisticsDto> selectBydate(Long appId, Date curDate) throws BizException;

    /**
     * @Description: 根据日期范围查询 商品id 查询 且可以按照pv/uv 排序查询
     */
    Page<GoodsStatisticsDto>  selectByStartEndDateAndItemId(GoodsStatisticParam goodsStatisticParam) throws BizException;

    /**
     * @Description: 根据日期范围查询  按照商品pv/uv 合计排序查询
     */
    GoodsTransDto selectByStartEndDateAndView(GoodsStatisticParam goodsStatisticParam) throws BizException;
}
