package cn.com.duiba.odps.center.api.remoteservice.yearreview;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.yearreview.BaseQueryDto;
import cn.com.duiba.odps.center.api.dto.yearreview.CreditsConsumeChartDto;
import cn.com.duiba.odps.center.api.dto.yearreview.CreditsConsumeDataDto;

import java.util.List;

/**
 * Created by zhangyongjie on 2022/5/20 2:45 下午
 * 【年度复盘】积分消耗情况
 */
@AdvancedFeignClient
public interface RemoteCreditsConsumeService {
    /**
     * 积分消耗情况概览
     * @param queryDto
     * @return
     * @throws Exception
     */
    CreditsConsumeDataDto queryOverView(BaseQueryDto queryDto) throws Exception;

    /**
     * 查询积分消耗折线图
     * @param queryDto
     * @return
     * @throws Exception
     */
    List<CreditsConsumeChartDto> queryCreditsConsumeChart(BaseQueryDto queryDto) throws Exception;
}
