package cn.com.duiba.odps.center.api.remoteservice.mengniumeirixianyu;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.mengniumeirixianyu.MengniuMeiRiXianYuActivityDTO;
import cn.com.duiba.odps.center.api.dto.mengniumeirixianyu.MengniuMeiRiXianYuDTO;
import cn.com.duiba.odps.center.api.dto.mengniumeirixianyu.MengniuMeiRiXianYuParticipantDTO;
import cn.com.duiba.odps.center.api.dto.mengniumeirixianyu.MengniuMeiRiXianYuWinnerDTO;
import cn.com.duiba.odps.center.api.param.mengniumeirixianyu.MeiRiXianYuQueryParam;
import cn.com.duiba.odps.center.api.param.mengniumeirixianyu.MengniuMeiRiXIanYuQueryParam;

import java.util.List;

/**
 * @Description 蒙牛每日鲜语数据接口
 * @Author huliangsheng
 * @Date 2024/10/23 11:26
 */
@AdvancedFeignClient
public interface RemoteMengNiuMeiRiXianYuService {

    /**
     * 分页查询总数据
     *
     * @param reqParam 查询参数
     * @return 分页后的总数据
     * @date 2024/10/23 15:12
     */
    List<MengniuMeiRiXianYuDTO> queryTotalDataByPage(MengniuMeiRiXIanYuQueryParam reqParam);

    /**
     * 查询总数据条数
     */
    int queryTotalDataCount();

    /**
     * 根据推送日期进行分页查询
     *
     * @param reqParam 查询参数
     * @return 分页后的查询数据
     * @date 2024/10/23 15:12
     */
    List<MengniuMeiRiXianYuDTO> pageQueryByPushData(MengniuMeiRiXIanYuQueryParam reqParam);

    /**
     * 根据推送日期查询总条数
     *
     * @param date 推送日期
     * @return 总条数
     */
    int countByDate(String date);

    /**
     * 根据推送日期分页查询活动信息数据
     */
    List<MengniuMeiRiXianYuActivityDTO> pageQueryByActivityInfo(MeiRiXianYuQueryParam reqParam);

    /**
     * 根据推送日期查询活动信息总条数
     */
    int countByActivityInfo(String date);

    /**
     * 根据推送日期分页查询中奖人员信息
     */
    List<MengniuMeiRiXianYuWinnerDTO> pageQueryByWinnerInfo(MeiRiXianYuQueryParam reqParam);

    /**
     * 根据推送日期查询中奖人员信息总条数
     */
    int countByWinnerInfo(String date);

    /**
     * 根据推送日期查询活动参与人员信息
     */
    List<MengniuMeiRiXianYuParticipantDTO> pageQueryByParticipantInfo(MeiRiXianYuQueryParam reqParam);

    /**
     * 根据推送日期查询活动参与人员信息总条数
     */
    int countByParticipantInfo(String date);

}
