package cn.com.duiba.odps.center.api.remoteservice.yearreview;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.yearreview.ItemStatCreditsTopDto;
import cn.com.duiba.odps.center.api.dto.yearreview.ItemStatExchangeTopDto;
import cn.com.duiba.odps.center.api.dto.yearreview.ItemStatVisitDto;

import java.util.Date;

/**
 * @author haojiahong
 * @date 2022-05-10
 */
@AdvancedFeignClient
public interface RemoteItemStatService {

    /**
     * 商品访问数据
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    ItemStatVisitDto getVisitData(Long appId, Date startTime, Date endTime);

    /**
     * 商品数据情况-商品兑换量top
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    ItemStatExchangeTopDto exchangeTop(Long appId, Date startTime, Date endTime);

    /**
     * 商品数据情况-商品积分消耗top
     *
     * @param appId
     * @param startTime
     * @param endTime
     * @return
     */
    ItemStatCreditsTopDto creditsTop(Long appId, Date startTime, Date endTime);



}
