package cn.com.duiba.odps.center.api.remoteservice.picclife;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.picclife.CommonActionDetailDto;
import cn.com.duiba.odps.center.api.dto.picclife.DuoBaAnActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.GfhbActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.GxfhActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.KouHongJiActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.PiccLifeGoodFortuneActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.PkActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.TongXinHuiJuActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.WishActionDto;
import cn.com.duiba.odps.center.api.dto.zyjy.PageList;
import cn.com.duiba.odps.center.api.param.picclife.QueryParam;

/**
 * 中国人保一体化报表数据推送
 *
 * @author zhangdaqing
 * @Description
 * @date 2023/12/29 23:19
 */
@AdvancedFeignClient
public interface RemotePiccLifeWishService {

    /**
     * 新年心愿remote
     *
     * @param pageNo    页码offset
     * @param pageSize  每页大小
     * @param dateStart yyyy-MM-dd HH:mm:ss
     * @param dateEnd   yyyy-MM-dd HH:mm:ss
     * @return result
     */
    Page<WishActionDto> listWishConsumerDetailDto(int pageNo, int pageSize, String dateStart, String dateEnd);


    /**
     * 传福气数据
     * @param query
     * @return
     */
    Page<PiccLifeGoodFortuneActionDto> listCfqModelByPage(QueryParam query);


    /**
     * 口红机remote
     *
     * @param pageNo    页码offset
     * @param pageSize  每页大小
     * @param dateStart yyyy-MM-dd HH:mm:ss
     * @param dateEnd   yyyy-MM-dd HH:mm:ss
     * @return result
     */
    Page<KouHongJiActionDto> listKouHongJiConsumerDetailDto(int pageNo, int pageSize, String dateStart, String dateEnd);


    /**
     * 多巴胺remote
     *
     * @param pageNo    页码offset
     * @param pageSize  每页大小
     * @param dateStart yyyy-MM-dd HH:mm:ss
     * @param dateEnd   yyyy-MM-dd HH:mm:ss
     * @return result
     */
    Page<DuoBaAnActionDto> listDuoBaAnConsumerDetailDto(int pageNo, int pageSize, String dateStart, String dateEnd);


    /**
     * 童心绘聚
     * @param pageNo
     * @param pageSize
     * @param dateStart
     * @param dateEnd
     * @return {@link Page}<{@link TongXinHuiJuActionDto}>
     */
    Page<TongXinHuiJuActionDto> listTongXinHuiJuConsumerDetailDto(int pageNo, int pageSize, String dateStart, String dateEnd);


    /**
     * 共享繁花remote
     *
     * @param pageNo    页码offset
     * @param pageSize  每页大小
     * @param queryDate 查询日期 yyyy-MM-dd
     * @return result
     */
    Page<GxfhActionDto> listGxfhConsumerDetailDto(int pageNo, int pageSize, String queryDate);

    /**
     * 瓜分红包
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @param queryDate 查询时间
     * @return
     */
    Page<GfhbActionDto> listGfhbConsumerDetailDto(int pageNo, int pageSize, String queryDate);

    /**
     * 瓜分红包
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @param queryDate 查询时间(格式yyyy-MM-dd)
     * @return 分页数据
     */
    Page<PkActionDto> listPkConsumerDetailDto(int pageNo, int pageSize, String queryDate);

    /**
     * 瓜分京东卡
     * @param date 日期（格式：yyyy-MM-dd）
     * @param pageSize 每页多少条
     * @param pageNo 第几页（从1开始）
     * @param lastId 上一页最后一条的id（没有传则null）
     * @return
     */
    PageList<CommonActionDetailDto> pageListGfjdkActionDetailDto(String date, int pageSize, int pageNo, Long lastId);

    /**
     * 寻宝大富翁
     * @param date 日期（格式：yyyy-MM-dd）
     * @param pageSize 每页多少条
     * @param pageNo 第几页（从1开始）
     * @param lastId 上一页最后一条的id（没有传则null）
     * @return
     */
    PageList<CommonActionDetailDto> pageListXbdfwActionDetailDto(String date, int pageSize, int pageNo, Long lastId);

    /**
     * 心愿奇缘
     * @param date 日期（格式：yyyy-MM-dd）
     * @param pageSize 每页多少条
     * @param pageNo 第几页（从1开始）
     * @param lastId 上一页最后一条的id（没有传则null）
     * @return
     */
    PageList<CommonActionDetailDto> pageListXyqyActionDetailDto(String date, int pageSize, int pageNo, Long lastId);


    /**
     * 一体化数据报表推送
     * @param tableName 一体化报表表名
     * @param date 日期（格式：yyyy-MM-dd）
     * @param pageSize 每页多少条
     * @param pageNo 第几页（从1开始）
     * @param lastId 上一页最后一条的id（没有传则null）
     * @return 分页数据
     */
    PageList<CommonActionDetailDto> pageListCommonActionDetailDto(String tableName, String date, int pageSize, int pageNo, Long lastId);
}
