package cn.com.duiba.odps.center.api.dto.paph;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:平安惠普活动访问数据
 */
@Data
public class PaphAccessDo implements Serializable {

    private static final long serialVersionUID = 8495257560734811807L;
    /**
     * 主键ID
     */
    private Long id;
    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动开始时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 活动结束时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 活动当前状态
     */
    private String activityStatus;

    /**
     * 用户 openID
     */
    private String openId;

    /**
     * 用户访问时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date visitTime;

    /**
     * 创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date gmtModified;
}
