package cn.com.duiba.odps.center.api.remoteservice.wanda;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.wanda.WandaOrderBillDTO;
import cn.com.duiba.odps.center.api.param.wanda.WandaOrderBillQueryParam;

/**
 * 万达酒店对账单明细远程服务接口
 * @author zhangdaqing
 * @Description 提供万达酒店对账单明细数据的查询服务
 * @date 2025/10/13 15:52
 */
@AdvancedFeignClient
public interface RemoteWandaOrderBillService {

    /**
     * 分页查询万达酒店对账单明细数据
     * 支持所有字段的条件查询和分页
     *
     * @param queryParam 查询参数，包含所有可搜索字段和分页信息
     * @return 对账单明细分页数据
     */
    Page<WandaOrderBillDTO> pageQueryOrderBillList(WandaOrderBillQueryParam queryParam);

    /**
     * 查询对账单明细数据总数
     * 根据查询参数统计符合条件的记录总数
     *
     * @param queryParam 查询参数
     * @return 符合条件的记录总数
     */
    int countOrderBillByCondition(WandaOrderBillQueryParam queryParam);

    /**
     * 根据订单号查询对账单明细
     *
     * @param orderNum 订单号
     * @return 对账单明细数据，如果不存在则返回null
     */
    WandaOrderBillDTO queryOrderBillByOrderNum(String orderNum);
}
