package cn.com.duiba.odps.center.api.remoteservice.luzhoulaojiao;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.lzlj.LzljChallengeDTO;
import cn.com.duiba.odps.center.api.dto.lzlj.LzljExchangeGoodsDTO;
import cn.com.duiba.odps.center.api.dto.lzlj.LzljJoinDTO;
import cn.com.duiba.odps.center.api.dto.lzlj.LzljPayDTO;
import cn.com.duiba.odps.center.api.dto.lzlj.LzljStatDTO;
import cn.com.duiba.odps.center.api.dto.lzlj.LzljViewGoodsDTO;
import cn.com.duiba.odps.center.api.dto.zyjy.PageList;
import cn.com.duiba.odps.center.api.param.lzlj.LzljDataQueryParam;

/**
 * @Description 泸州老窖远程数据服务
 * @Author huliangsheng
 * @Date 2025/3/17 17:22
 */
@AdvancedFeignClient
public interface RemoteLuzhoulaojiaoService {

    /**
     * 查询统计数据
     */
    PageList<LzljStatDTO> queryStatDataPageList(LzljDataQueryParam reqParam);

    /**
     * 查询用户参与明细
     */
    PageList<LzljJoinDTO> queryUserParticipateDetailPageList(LzljDataQueryParam reqParam);

    /**
     * 查询浏览商品明细
     */
    PageList<LzljViewGoodsDTO> queryViewGoodsDetailPageList(LzljDataQueryParam reqParam);

    /**
     * 查询活动兑换记录
     */
    PageList<LzljExchangeGoodsDTO> queryExchangeDetailPageList(LzljDataQueryParam reqParam);

    /**
     * 查询互动挑战明细
     */
    PageList<LzljChallengeDTO> queryChallengeDetailPageList(LzljDataQueryParam reqParam);

    /**
     * 查询购买消费金额明细
     */
    PageList<LzljPayDTO> queryBuyDetailPageList(LzljDataQueryParam reqParam);

}
