package cn.com.duiba.odps.center.api.dto.hsbc;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @description dm_tb_hfhx_app_item_df
 * @author huakai
 * @date 2024-04-28
 */
@Data
public class DmHfhxAppItemDfDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 自增主键
    */
    private Long id;

    /**
    * app_id
    */
    private String appId;

    /**
    * 自有or兑吧商品
    */
    private Long isOwner;

    /**
    * 商品id
    */
    private Long appItemId;

    /**
    * sku_id
    */
    private Long skuId;

    /**
    * 商品类型
    */
    private String itemType;

    /**
    * 分组名称
    */
    private String itemClassifyName;

    /**
    * 自定义角标
    */
    private String customTag;

    /**
    * 兑换按钮文案
    */
    private String buttonText;

    /**
    * 是否CXA商品
    */
    private Long caxGoods;

    /**
    * 商品名称
    */
    private String itemName;

    /**
    * 商品卖点
    */
    private String sellingPoint;

    /**
    * 规格
    */
    private String attributeValue;

    /**
    * 库存状态
    */
    private Long stockStatus;

    /**
    * 可售库存
    */
    private Long curStock;

    /**
    * 售价类型
    */
    private Long exchangeType;

    /**
    * 售价
    */
    private Long facePrice;

    /**
    * 划线价
    */
    private Long marketPaice;

    /**
    * 成本
    */
    private Long costPrice;

    /**
    * 商品编码
    */
    private String merchantCoding;

    /**
    * 每人限购
    */
    private String limitScopeCount;

    /**
    * 商品审核
    */
    private Long itemAudit;

    /**
    * 地区限制
    */
    private Long limitRegion;

    /**
    * 会员限制
    */
    private Long vipLimit;

    /**
    * 运费类型
    */
    private String expressType;

    /**
    * 运费价格
    */
    private String expressPrice;

    /**
    * 运费模板
    */
    private String expressTemplateId;

    /**
    * 待发货文案
    */
    private String alertMessage;

    /**
    * 图文详情
    */
    private String description;

    /**
    * 兑换价格
    */
    private Long customPrice;

    /**
    * 兑换积分
    */
    private Long customCredits;

    /**
    * 商品状态
    */
    private String itemStatus;

    /**
    * 每日限量
    */
    private Long limitEverydayQuantity;

    /**
    * 兑换日期限制
    */
    private String limitDate;

    /**
    * 是否允许原价购买（0-否，1-允许）
    */
    private String originalPriceBuy;

    /**
    * 商品创建时间
    */
    private String itemCreatedTime;

    /**
    * 自动上架时间
    */
    private String autoOnDate;

    /**
    * 自动下架时间
    */
    private String autoOffDate;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 是否删除 0 未删除 1 已删除
     */
    private Integer isDeleted;

    public DmHfhxAppItemDfDto() {}
}