package cn.com.duiba.odps.center.api.dto.yearreview;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author haojiahong
 * @date 2022-05-10
 */
public class OrderStatVisitDto implements Serializable {

    private static final long serialVersionUID = -1471870917376469209L;

    /**
     * 总订单量
     */
    private Long totalNum;

    /**
     * 总订单人数
     */
    private Long totalPerson;

    /**
     * 兑换订单量
     */
    private Long exchangeNum;

    /**
     * 活动订单量
     */
    private Long actNum;

    /**
     * 月均订单量
     */
    private Long perMonthNum;

    /**
     * 月均订单转化率，保留两位小数，例如65.75
     */
    private String perMonthRate;


    /**
     * 月订单转化率，折线图
     */
    private List<MonthBeanDto> rateList;


    public static class MonthBeanDto implements Serializable {

        private static final long serialVersionUID = 8342051140664399305L;

        /**
         * 时间，格式yyyy-MM-dd HH:mm:ss
         */
        private Date date;

        /**
         * 订单转化率，保留两位小数，例如65.75
         */
        private String rate;

        public Date getDate() {
            return date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getRate() {
            return rate;
        }

        public void setRate(String rate) {
            this.rate = rate;
        }
    }

    public Long getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Long totalNum) {
        this.totalNum = totalNum;
    }

    public Long getTotalPerson() {
        return totalPerson;
    }

    public void setTotalPerson(Long totalPerson) {
        this.totalPerson = totalPerson;
    }

    public Long getExchangeNum() {
        return exchangeNum;
    }

    public void setExchangeNum(Long exchangeNum) {
        this.exchangeNum = exchangeNum;
    }

    public Long getActNum() {
        return actNum;
    }

    public void setActNum(Long actNum) {
        this.actNum = actNum;
    }

    public Long getPerMonthNum() {
        return perMonthNum;
    }

    public void setPerMonthNum(Long perMonthNum) {
        this.perMonthNum = perMonthNum;
    }

    public String getPerMonthRate() {
        return perMonthRate;
    }

    public void setPerMonthRate(String perMonthRate) {
        this.perMonthRate = perMonthRate;
    }

    public List<MonthBeanDto> getRateList() {
        return rateList;
    }

    public void setRateList(List<MonthBeanDto> rateList) {
        this.rateList = rateList;
    }
}
