package cn.com.duiba.odps.center.api.dto.risk;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import java.io.Serializable;
import java.util.LinkedHashMap;

/**
 * @author zhangdaqing
 * @date 2024/08/27
 */
@Getter
@Setter
@NoArgsConstructor
public class RiskSendMsgDto implements Serializable {

    /**
     * 项目id（10进制）
     */
    private String projectId;

    /**
     * 标题
     */
    private String title;

    /**
     * 消息信息
     * type=0时 普通文本
     * type=1时 json ["str1","str2"]，字符串分行展示
     */
    private String msg;

    /**
     * 消息类型 0-普通文本 1-markdown 2-纯markdown 3-卡片类型
     */
    private Integer type;

    /**
     * 被@的用户id ["userId","userId"]
     */
    private String atUserIds;

    /**
     * 被@前面的描述语
     */
    private String atMsg;

    /**
     * 卡片按钮展示样式 type == 3
     *  0 所有按钮横行屁啊咧
     *  1 每个按钮自成一行
     *  默认 1
     */
    private Integer actionCardType;

    /**
     * type == 3 必填
     * btnInfo《"按钮名称", "按钮地址(点击按钮跳转地址)"》
     */
    private LinkedHashMap<String, String> btnInfo;

    @Builder
    public RiskSendMsgDto(String projectId, String title, String msg, Integer type, String atUserIds, String atMsg, Integer actionCardType, LinkedHashMap<String, String> btnInfo) {
        this.projectId = projectId;
        this.title = title;
        this.msg = msg;
        this.type = type;
        this.atUserIds = atUserIds;
        this.atMsg = atMsg;
        this.actionCardType = actionCardType;
        this.btnInfo = btnInfo;
    }
}
