package cn.com.duiba.odps.center.api.dto.zgrs;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:中国人寿植树日数据报表
 *
 * @author lyj
 */
@Data
public class ZgrsPtDataReportDailyDO implements Serializable {


    private static final long serialVersionUID = -2282368238344910275L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 开发者用户id
     */
    private String userId;

    /**
     * 统计时间
     * 日期格式：yyyy-MM-dd
     */
    private String actTime;

    /**
     * 访问渠道
     */
    private String channel;

    /**
     * 访问次数
     */
    private Long visitCnt;

    /**
     * 平均停留时长
     */
    private Long duration;

    /**
     * 互动次数
     */
    private Long actCnt;

    /**
     * 参与游戏次数
     */
    private Long playName;

    /**
     * 转发活动次数
     */
    private Long shareCnt;

    /**
     * 邀请新用户数
     */
    private Long inviteCnt;

    /**
     * 完成任务次数
     */
    private Long compTask;

    /**
     * 抽中奖品
     */
    private String winPrizeName;

    /**
     * 兑换奖品
     */
    private String prizeName;

    /**
     * 点击跳转链接次数
     */
    private Long clickLink;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}
