package cn.com.duiba.odps.center.api.remoteservice.genie;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.genie.ChartAndSqlDto;
import cn.com.duiba.odps.center.api.dto.genie.ChartDataDto;
import cn.com.duiba.odps.center.api.dto.genie.GenieSqlConfigurationDto;
import cn.com.duiba.odps.center.api.param.genie.ChartDataParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.odps.center.api.dto.genie.GenieChartDto;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

@AdvancedFeignClient
public interface RemoteGenieChartService {
    /**
     * 分页查询图表数据
     */
    Page<GenieChartDto> getChartList(Integer pageNo, Integer pageSize);
    /**
     * 根据图表名称，分页查询图表数据
     */
    Page<GenieChartDto> getChartListByName(String chartName,Integer pageNo,Integer pageSize);
    /**
     * 图表详情保存
     */
    Long saveChart (ChartAndSqlDto chartAndSqlDto);
    /**
     * 根据id获取图表
     */
    GenieChartDto getChartById(Long chartId);
    /**
     * 查询图表数据
     * @param chartDataParam
     * @return
     * @throws BizException
     */
    ChartDataDto getChartData(ChartDataParam chartDataParam) throws BizException;
    /**
     * 根据id删除图表
     */
    Integer deleteChartById(Long id);
    /**
     * 获取图表详情
     */
    ChartAndSqlDto getChartAndSqlByChartId(Long chartId);

    Integer getDataListCount(ChartDataParam chartDataParam) throws BizException;

    Integer updateDeliveryState(Integer deliveryState, Long id);

    List<JSONObject> getDataListChartData(ChartDataParam chartDataParam) throws BizException;
}
