package cn.com.duiba.odps.center.api.remoteservice.picclife;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.picclife.DuoBaAnActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.KouHongJiActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.PiccLifeGoodFortuneActionDto;
import cn.com.duiba.odps.center.api.dto.picclife.WishActionDto;
import cn.com.duiba.odps.center.api.param.picclife.QueryParam;

/**
 * 中国人保一体化报表数据推送
 *
 * @author zhangdaqing
 * @Description
 * @date 2023/12/29 23:19
 */
@AdvancedFeignClient
public interface RemotePiccLifeWishService {

    /**
     * 新年心愿remote
     *
     * @param pageNo    页码offset
     * @param pageSize  每页大小
     * @param dateStart yyyy-MM-dd HH:mm:ss
     * @param dateEnd   yyyy-MM-dd HH:mm:ss
     * @return result
     */
    Page<WishActionDto> listWishConsumerDetailDto(int pageNo, int pageSize, String dateStart, String dateEnd);


    /**
     * 传福气数据
     * @param query
     * @return
     */
    Page<PiccLifeGoodFortuneActionDto> listCfqModelByPage(QueryParam query);


    /**
     * 口红机remote
     *
     * @param pageNo    页码offset
     * @param pageSize  每页大小
     * @param dateStart yyyy-MM-dd HH:mm:ss
     * @param dateEnd   yyyy-MM-dd HH:mm:ss
     * @return result
     */
    Page<KouHongJiActionDto> listKouHongJiConsumerDetailDto(int pageNo, int pageSize, String dateStart, String dateEnd);


    /**
     * 多巴胺remote
     *
     * @param pageNo    页码offset
     * @param pageSize  每页大小
     * @param dateStart yyyy-MM-dd HH:mm:ss
     * @param dateEnd   yyyy-MM-dd HH:mm:ss
     * @return result
     */
    Page<DuoBaAnActionDto> listDuoBaAnConsumerDetailDto(int pageNo, int pageSize, String dateStart, String dateEnd);
}
